/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.cim.provider.rs6k.SystemProfileInstProv;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscLockManager;
import com.ibm.hsc.common.util.HscPerformance;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.ProviderLceCommunication;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.lpar.LPARInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbem.provider20.AssociatorProvider;
import org.snia.wbemcfg.GlobalConfig;

public class InSysProfileInstProv
implements InstanceProvider,
AssociatorProvider {
    CIMOMHandle m_CIMOMHandle = null;
    private ProviderCIMOMHandle pch = null;
    InstanceProvider ip = null;
    private static final int LPARProviderDebug = 2;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile InstanceProvider - initialize");
        }
        Trace.trace("apishscT", "-> initialize");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("initialize - CIMOMHandle = " + cIMOMHandle);
        }
        Trace.trace("apishscF", "CIMOMHandle = " + cIMOMHandle);
        this.m_CIMOMHandle = cIMOMHandle;
        this.pch = (ProviderCIMOMHandle)cIMOMHandle;
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("initialize - ProviderCIMOMHandle = " + this.pch);
        }
        Trace.trace("apishscD", "ProviderCIMOMHandle = " + this.pch);
        this.ip = this.pch.getInternalProvider();
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("initalize - InternalProvider = " + this.ip);
        }
        Trace.trace("apishscF", "InternalProvider = " + this.ip);
        Trace.trace("apishscT", "<- initialize");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
    }

    public void cleanup() throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile InstanceProvider - cleanup");
        }
        Trace.trace("apishscT", "-> cleanup");
        this.ip.cleanup();
        Trace.trace("apishscT", "<- cleanup");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        int n = HscPerformance.startTransaction("InSysProfileInstProv+createInstance");
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMInstance.getProperty("Setting").getValue().getValue();
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_LparProfile"), false);
        String string = (String)cIMInstance2.getProperty("PartitionName").getValue().getValue();
        String string2 = string.substring(string.indexOf(42) + 1);
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string2);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("createInstance"));
            cIMObjectPath2 = this.createInstance0(cIMObjectPath, cIMInstance);
            Object var12_11 = null;
            hscCecLock.Unlock();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            hscCecLock.Unlock();
            HscPerformance.endTransaction(n);
            throw throwable;
        }
        HscPerformance.endTransaction(n);
        return cIMObjectPath2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath createInstance0(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Hashtable hashtable = null;
        HscProviderSocket hscProviderSocket = null;
        CIMObjectPath cIMObjectPath2 = null;
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile InstanceProvider - createInstance");
        }
        Trace.trace("apishscT", "-> createInstance");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInstance - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInstance - CIMInstance  = " + cIMInstance);
        }
        Trace.trace("apishscT", "CIMInstance = " + cIMInstance);
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMInstance.getProperty("Context").getValue().getValue();
        CIMObjectPath cIMObjectPath4 = (CIMObjectPath)cIMInstance.getProperty("Setting").getValue().getValue();
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_SystemProfile"), false);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ncreateInstance - System profile exists in CIMOM");
        }
        Trace.trace("apishscD", "System Profile exists in CIMOM");
        CIMInstance cIMInstance3 = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath4, new CIMClass("IBMHSC_LparProfile"), false);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ncreateInstance - LPAR Profile exists in CIMOM");
        }
        Trace.trace("apishscD", "Partition Profile exists in CIMOM");
        String string = (String)cIMInstance3.getProperty("PartitionName").getValue().getValue();
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ncreateInstance - PartitionName = " + string);
        }
        Trace.trace("apishscD", "PartitionName = " + string);
        String string2 = string.substring(string.indexOf(42) + 1);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ncreateInstance - CECName = " + string2);
        }
        Trace.trace("apishscD", "CECName = " + string2);
        String string3 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
        Trace.trace("apishscD", "System Profile SettingID = " + string3);
        String string4 = (String)cIMInstance3.getProperty("SettingID").getValue().getValue();
        Trace.trace("apishscD", "LPARProfile SettingID = " + string4);
        short s = Short.parseShort(string.substring(0, 3));
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ncreateInstance - partitionID = " + s);
        }
        Trace.trace("apishscD", "partitionID = " + s);
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ncreateInstance - LCESocket = " + hscProviderSocket);
            }
            Trace.trace("apishscF", "Obtained LCESocket");
            hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"1", HscProviderUtils.getHscID(this.m_CIMOMHandle)}, hscProviderSocket);
            if (hashtable == null) {
                throw new HSCCIMException("01F5");
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ncreateInstance - Locked CSP");
            }
            Trace.trace("apishscF", "Locked CSP");
            cIMObjectPath2 = InSysProfileInstProv.createInSysProfile(this.m_CIMOMHandle, cIMObjectPath, cIMInstance, string2, string3, string4, s, true, hscProviderSocket);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID(this.m_CIMOMHandle)}, hscProviderSocket);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("\ncreateInstance - Unlocked CSP");
                    }
                    Trace.trace("apishscF", "Unlocked CSP");
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    HSCLogUtils.serverLog(throwable3, HSCLogUtils._SysProfileClassLogInfo);
                    throw new HSCCIMException("01F6");
                }
                finally {
                    try {
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                        }
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("\ncreateInstance - Released LCESocket");
                        }
                        Trace.trace("apishscF", "Released LCESocket");
                    }
                    catch (Throwable throwable4) {
                        HSCLogUtils.serverLog(throwable4, HSCLogUtils._SysProfileClassLogInfo);
                    }
                }
            }
        }
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID(this.m_CIMOMHandle)}, hscProviderSocket);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ncreateInstance - Unlocked CSP");
            }
            Trace.trace("apishscF", "Unlocked CSP");
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
            throw new HSCCIMException("01F6");
        }
        finally {
            try {
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("\ncreateInstance - Released LCESocket");
                }
                Trace.trace("apishscF", "Released LCESocket");
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
            }
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInstance -  return CIMObjectPath = " + cIMObjectPath2);
        }
        Trace.trace("apishscF", "returned CIMObjectPath = " + cIMObjectPath2);
        Trace.trace("apishscT", "<- createInstance");
        if (GlobalConfig.debugLevel((int)2) <= 0) return cIMObjectPath2;
        System.out.print("********************************");
        System.out.println("********************************");
        return cIMObjectPath2;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        int n = HscPerformance.startTransaction("InSysProfileInstProv+enumInstances_1");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile InstanceProvider - enumInstances");
        }
        Trace.trace("apishscT", "-> enumInstances");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("enumInstances - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("enumInstances - boolean = " + bl);
        }
        Trace.trace("apishscF", "boolean = " + bl);
        Vector vector = CimomWrapper.enumInstances(this.m_CIMOMHandle, cIMObjectPath, bl, cIMClass);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("enumInstances - Return Vector = " + vector);
        }
        Trace.trace("apishscF", "return Vector = " + vector);
        Trace.trace("apishscT", "<- enumInstances");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        HscPerformance.endTransaction(n);
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        int n = HscPerformance.startTransaction("InSysProfileInstProv+enumInstances_2");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile InstanceProvider - enumInstances");
        }
        Trace.trace("apishscT", "-> enumInstances");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("enumInstances - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("enumInstances - boolean = " + bl);
        }
        Trace.trace("apishscF", "boolean = " + bl);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("enumInstances - boolean = " + bl2);
        }
        Trace.trace("apishscF", "boolean = " + bl2);
        Vector vector = CimomWrapper.enumInstances(this.m_CIMOMHandle, cIMObjectPath, bl, cIMClass, bl2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("enumInstances - Return Vector = " + vector);
        }
        Trace.trace("apishscF", "return Vector = " + vector);
        Trace.trace("apishscT", "<- enumInstances");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        HscPerformance.endTransaction(n);
        return vector;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        int n = HscPerformance.startTransaction("InSysProfileInstProv+getInstance");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile InstanceProvider - getInstance");
        }
        Trace.trace("apishscT", "-> getInstance");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("getInstance - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("getInstance - boolean = " + bl);
        }
        Trace.trace("apishscF", "boolean = " + bl);
        CIMInstance cIMInstance = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath, cIMClass, bl);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("getInstance - Return CIMInstance = " + cIMInstance);
        }
        Trace.trace("apishscF", "return CIMInstance = " + cIMInstance);
        Trace.trace("apishscT", "<- getInstance");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        HscPerformance.endTransaction(n);
        return cIMInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        int n = HscPerformance.startTransaction("InSysProfileInstProv+deleteInstance");
        CIMInstance cIMInstance = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_InSysProfile"), false);
        System.out.println("=========InSysProfileInstProv.deleteInstance");
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty("Setting").getValue().getValue();
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
        String string = (String)cIMInstance2.getProperty("PartitionName").getValue().getValue();
        String string2 = string.substring(string.indexOf(42) + 1);
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string2);
        try {
            hscCecLock.Lock(hscLockManager.getLockType("deleteInstance"));
            this.deleteInstance0(cIMObjectPath);
            Object var11_10 = null;
            hscCecLock.Unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            hscCecLock.Unlock();
            HscPerformance.endTransaction(n);
            throw throwable;
        }
        HscPerformance.endTransaction(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteInstance0(CIMObjectPath cIMObjectPath) throws CIMException {
        Hashtable hashtable = null;
        HscProviderSocket hscProviderSocket = null;
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile InstanceProvider - deleteInstance");
        }
        Trace.trace("apishscT", "-> deleteInstance");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInstance - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        CIMInstance cIMInstance = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_InSysProfile"), false);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ndeleteInstance - ci = " + cIMInstance);
        }
        CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMInstance.getProperty("Context").getValue().getValue();
        CIMObjectPath cIMObjectPath3 = (CIMObjectPath)cIMInstance.getProperty("Setting").getValue().getValue();
        CIMInstance cIMInstance2 = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_SystemProfile"), false);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ndeleteInstance - System profile exists in CIMOM");
        }
        Trace.trace("apishscD", "System Profile exists in CIMOM");
        CIMInstance cIMInstance3 = CimomWrapper.getInstance(this.m_CIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_LparProfile"), false);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ndeleteInstance - Partition Profile exists in CIMOM");
        }
        Trace.trace("apishscD", "Partition Profile exists in CIMOM");
        String string = (String)cIMInstance3.getProperty("PartitionName").getValue().getValue();
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ndeleteInstance - PartitionName = " + string);
        }
        Trace.trace("apishscD", "PartitionName = " + string);
        String string2 = string.substring(string.indexOf(42) + 1);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ndeleteInstance - CECName = " + string2);
        }
        Trace.trace("apishscD", "CECName = " + string2);
        String string3 = (String)cIMInstance3.getProperty("SettingID").getValue().getValue();
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ndeleteInstance - LCESocket = " + hscProviderSocket);
            }
            Trace.trace("apishscF", "Obtained LCESocket");
            hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"1", HscProviderUtils.getHscID(this.m_CIMOMHandle)}, hscProviderSocket);
            if (hashtable == null) {
                throw new HSCCIMException("01F5");
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ndeleteInstance - Locked CSP");
            }
            Trace.trace("apishscF", "Locked CSP");
            InSysProfileInstProv.deleteInSysProfile(this.m_CIMOMHandle, cIMObjectPath, string2, cIMObjectPath2, string3, Short.parseShort(string.substring(0, 3)), false, true, hscProviderSocket);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID(this.m_CIMOMHandle)}, hscProviderSocket);
                    if (GlobalConfig.debugLevel((int)2) > 0) {
                        System.out.println("\ndeleteInstance - Unlocked CSP");
                    }
                    Trace.trace("apishscF", "Unlocked CSP");
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    HSCLogUtils.serverLog(throwable3, HSCLogUtils._SysProfileClassLogInfo);
                    throw new HSCCIMException("01F6");
                }
                finally {
                    try {
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                        }
                        if (GlobalConfig.debugLevel((int)2) > 0) {
                            System.out.println("\ndeleteInstance - Released LCESocket");
                        }
                        Trace.trace("apishscF", "Released LCESocket");
                    }
                    catch (Throwable throwable4) {
                        HSCLogUtils.serverLog(throwable4, HSCLogUtils._SysProfileClassLogInfo);
                    }
                }
            }
        }
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID(this.m_CIMOMHandle)}, hscProviderSocket);
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ndeleteInstance - Unlocked CSP");
            }
            Trace.trace("apishscF", "Unlocked CSP");
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
            throw new HSCCIMException("01F6");
        }
        finally {
            try {
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("\ndeleteInstance - Released LCESocket");
                }
                Trace.trace("apishscF", "Released LCESocket");
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
            }
        }
        Trace.trace("apishscT", "<- deleteInstance");
        if (GlobalConfig.debugLevel((int)2) <= 0) return;
        System.out.print("********************************");
        System.out.println("********************************");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        int n = HscPerformance.startTransaction("InSysProfileInstProv+setInstance");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("DefaultLparProfile InstanceProvider - setInstance");
        }
        try {
            try {
                CimomWrapper.setInstance((CIMOMHandle)this.pch, cIMObjectPath, cIMInstance);
            }
            catch (Throwable throwable) {
                throw new HSCCIMException(throwable);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            HscPerformance.endTransaction(n);
            throw throwable;
        }
        HscPerformance.endTransaction(n);
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        System.out.print("********************************");
        System.out.println("********************************");
        System.out.println("LPARProfile InternalProvider - execQuery");
        System.out.println("execQuery - CIMObjectPath = " + cIMObjectPath);
        System.out.println("execQuery - String = " + string);
        System.out.println("execQuery - int = " + n);
        Vector vector = CimomWrapper.execQuery(this.m_CIMOMHandle, cIMObjectPath, string, n, cIMClass);
        System.out.println("execQuery - Return Vector = " + vector);
        System.out.print("********************************");
        System.out.println("********************************");
        return vector;
    }

    public Vector associatorNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile AssociatorProvider - associatorNames");
        }
        Trace.trace("apishscT", "-> associatorNames");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associatorNames - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associatorNames - CIMObjectPath = " + cIMObjectPath2);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associatorNames - String = " + string2);
        }
        Trace.trace("apishscF", "String = " + string2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associatorNames - String = " + string3);
        }
        Trace.trace("apishscF", "String = " + string3);
        Vector vector = CimomWrapper.associatorNames(this.m_CIMOMHandle, cIMObjectPath, cIMObjectPath2, string, string2, string3);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associatorNames - Return Vector = " + vector);
        }
        Trace.trace("apishscF", "Return vector = " + vector);
        Trace.trace("apishscT", "<- associatorNames");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        return vector;
    }

    public Vector associators(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, String string2, String string3, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile AssociatorProvider - associators");
        }
        Trace.trace("apishscT", "-> associators");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - CIMObjectPath = " + cIMObjectPath2);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - String = " + string2);
        }
        Trace.trace("apishscF", "String = " + string2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - String = " + string3);
        }
        Trace.trace("apishscF", "String = " + string3);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - boolean = " + bl);
        }
        Trace.trace("apishscF", "boolean = " + bl);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - boolean = " + bl2);
        }
        Trace.trace("apishscF", "boolean = " + bl2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - String[] = " + stringArray);
        }
        Vector vector = CimomWrapper.associators(this.m_CIMOMHandle, cIMObjectPath, cIMObjectPath2, string, string2, string3, bl, bl2, stringArray);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("associators - Return Vector = " + vector);
        }
        Trace.trace("apishscF", "Return vector = " + vector);
        Trace.trace("apishscT", "<- associators");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        return vector;
    }

    public Vector referenceNames(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile AssociatorProvider - referenceNames");
        }
        Trace.trace("apishscT", "-> referenceNames");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("referenceNames - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("referenceNames - CIMObjectPath = " + cIMObjectPath2);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("referenceNames - String = " + string);
        }
        Trace.trace("apishscF", "String = " + string);
        Vector vector = CimomWrapper.referenceNames(this.m_CIMOMHandle, cIMObjectPath, cIMObjectPath2, string);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("referenceNames - Return Vector = " + vector);
        }
        Trace.trace("apishscF", "Return Vector = " + vector);
        Trace.trace("apishscT", "<- referenceNames");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        return vector;
    }

    public Vector references(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, String string, boolean bl, boolean bl2, String[] stringArray) throws CIMException {
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile AssociatorProvider - references");
        }
        Trace.trace("apishscT", "-> references");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("referencess - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("references - CIMObjectPath = " + cIMObjectPath2);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("references - String = " + string);
        }
        Trace.trace("apishscF", "String = " + string);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("references - boolean = " + bl);
        }
        Trace.trace("apishscF", "boolean = " + bl);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("references - boolean = " + bl2);
        }
        Trace.trace("apishscF", "boolean = " + bl2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("references - String[] = " + stringArray);
        }
        Vector vector = CimomWrapper.references(this.m_CIMOMHandle, cIMObjectPath, cIMObjectPath2, string, bl, bl2, stringArray);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("references - Return Vector = " + vector);
        }
        Trace.trace("apishscF", "Return vector = " + vector);
        Trace.trace("apishscT", "<- references");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        return vector;
    }

    public static CIMObjectPath createInSysProfile(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, String string, String string2, String string3, short s, boolean bl, HscProviderSocket hscProviderSocket) throws CIMException {
        Vector vector = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMObjectPath cIMObjectPath4 = null;
        CIMInstance cIMInstance2 = null;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        Enumeration enumeration3 = null;
        int n = -1;
        int n2 = -1;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfile - createInSysProfile");
        }
        Trace.trace("apishscT", "-> createInSysProfile");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - CIMOMHandle = " + cIMOMHandle);
        }
        Trace.trace("apishscF", "CIMOMHandle = " + cIMOMHandle);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - CIMInstance = " + cIMInstance);
        }
        Trace.trace("apishscF", "CIMInstance = " + cIMInstance);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - CECName = " + string);
        }
        Trace.trace("apishscF", "CECName = " + string);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - SystemProfileSettingID = " + string2);
        }
        Trace.trace("apishscF", "SystemProfileSettingID = " + string2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - LPARProfileSettingID = " + string3);
        }
        Trace.trace("apishscF", "LPARProfileSettingID = " + string3);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - partitionID = " + s);
        }
        Trace.trace("apishscF", "partitionID = " + s);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - broadcastEvent = " + bl);
        }
        Trace.trace("apishscF", "broadcastEvent = " + bl);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - HscProviderSocket = " + hscProviderSocket);
        }
        Trace.trace("apishscF", "HscProviderSocket = " + hscProviderSocket);
        cIMObjectPath3 = (CIMObjectPath)cIMInstance.getProperty("Context").getValue().getValue();
        cIMObjectPath4 = (CIMObjectPath)cIMInstance.getProperty("Setting").getValue().getValue();
        enumeration = CimomWrapper.associatorNames(cIMOMHandle, new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2"), cIMObjectPath3, null, null, null).elements();
        if (enumeration.hasMoreElements()) {
            enumeration2 = CimomWrapper.associators(cIMOMHandle, new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2"), (CIMObjectPath)enumeration.nextElement(), "IBMHSC_Partition", "Setting", "Element", true, true, null).elements();
            enumeration3 = CimomWrapper.associators(cIMOMHandle, new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2"), cIMObjectPath4, "IBMHSC_LparProfile", "Setting", "Element", true, true, null).elements();
            if (enumeration2.hasMoreElements() && enumeration3.hasMoreElements()) {
                n = ((UnsignedInt8)((CIMInstance)enumeration2.nextElement()).getProperty("PartitionType").getValue().getValue()).intValue();
                n2 = ((UnsignedInt8)((CIMInstance)enumeration3.nextElement()).getProperty("PartitionType").getValue().getValue()).intValue();
                string4 = (String)LPARInfo.PARTITION_TYPE_MAP.get(Integer.toString(n));
                string5 = (String)LPARInfo.PARTITION_TYPE_MAP.get(Integer.toString(n2));
                cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_SystemProfile"), false);
                string6 = (String)cIMInstance2.getProperty("UserDefinedName").getValue().getValue();
                cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath4, new CIMClass("IBMHSC_LparProfile"), false);
                string7 = (String)cIMInstance2.getProperty("UserDefinedName").getValue().getValue();
                if (GlobalConfig.debugLevel((int)2) > 0) {
                    System.out.println("\ncreateInSysProfile - " + string6 + " contains " + string4 + " partition profiles");
                    System.out.println("\ncreateInSysProfile - " + string7 + " is for " + string5);
                }
                Trace.trace("apishscD", string6 + " contains " + string4 + " partition profiles");
                Trace.trace("apishscD", string7 + " is for " + string5);
                if (n != n2) {
                    throw new HSCCIMException("09CE", new String[]{string7, string5, string6, string4});
                }
            }
        }
        if ((vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getSysProfile(string2, hscProviderSocket)) == null) {
            throw new HSCCIMException("09C6");
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ncreateInSysProfile - System Profile exists in NVRAM");
        }
        Trace.trace("apishscD", "System Profile exists in NVRAM");
        if (s != 0) {
            vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getLPARProfile(string3, hscProviderSocket);
            if (vector == null) {
                throw new HSCCIMException("07D3");
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ncreateInSysProfile - Partition Profile exists in NVRAM");
            }
            Trace.trace("apishscD", "Partition Profile exists in NVRAM");
        }
        cIMObjectPath2 = CimomWrapper.createInstance(cIMOMHandle, cIMObjectPath, cIMInstance);
        AsynchEventManager.sendIndication(1, cIMInstance, null);
        ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).addLparProfileToSysProfile(string2, string3, (byte)s, hscProviderSocket);
        if (bl) {
            try {
                HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_SYSTEM_PROFILE_ADD_LPAR_PROFILE", new String[]{"0", HscProviderUtils.getHscID(cIMOMHandle), "8", "4", string2, Integer.toHexString(s), string3}, hscProviderSocket);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
            }
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("createInSysProfile - Returned CIMObjectPath = " + cIMObjectPath2);
        }
        Trace.trace("apishscF", "Return CIMObjectPath = " + cIMObjectPath2);
        Trace.trace("apishscT", "<- createInSysProfile");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        return cIMObjectPath2;
    }

    public static void deleteInSysProfile(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string, CIMObjectPath cIMObjectPath2, String string2, short s, boolean bl, boolean bl2, HscProviderSocket hscProviderSocket) throws CIMException {
        Vector vector = null;
        CIMInstance cIMInstance = null;
        String string3 = null;
        Enumeration enumeration = null;
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("InSysProfileInstProv - deleteInSysProfile");
        }
        Trace.trace("apishscT", "-> deleteInSysProfile");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - CIMOMHandle = " + cIMOMHandle);
        }
        Trace.trace("apishscF", "CIMOMHandle = " + cIMOMHandle);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("apishscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - CECName = " + string);
        }
        Trace.trace("apishscF", "CECName = " + string);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - Context = " + cIMObjectPath2);
        }
        Trace.trace("apishscF", "Context = " + cIMObjectPath2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - LPARProfileSettingID = " + string2);
        }
        Trace.trace("apishscF", "LPARProfileSettingID = " + string2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - lparId = " + s);
        }
        Trace.trace("apishscF", "lparId = " + s);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - caller = " + bl);
        }
        Trace.trace("apishscF", "caller = " + bl);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - broadcastEvent = " + bl2);
        }
        Trace.trace("apishscF", "broadcastEvent = " + bl2);
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - HscProviderSocket = " + hscProviderSocket);
        }
        Trace.trace("apishscF", "HscProviderSocket = " + hscProviderSocket);
        cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_SystemProfile"), false);
        string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("deleteInSysProfile - SystemProfileSettingID = " + string3);
        }
        Trace.trace("apishscF", "SystemProfileSettingID = " + string3);
        vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getSysProfile(string3, hscProviderSocket);
        if (vector == null) {
            throw new HSCCIMException("09C6");
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ndeleteInSysProfile - System Profile exists in NVRAM");
        }
        Trace.trace("apishscF", "System Profile exists in NVRAM");
        if (s != 0) {
            vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getLPARProfile(string2, hscProviderSocket);
            if (vector == null) {
                throw new HSCCIMException("07D3");
            }
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ndeleteInSysProfile - Partition Profile exists in NVRAM");
            }
            Trace.trace("apishscF", "Partition Profile exists in NVRAM");
        }
        ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).deleteLparProfileFromSysProfile(string3, string2, hscProviderSocket);
        if (bl2) {
            try {
                HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_SYSTEM_PROFILE_REMOVE_LPAR_PROFILE", new String[]{"0", HscProviderUtils.getHscID(cIMOMHandle), "8", "8", string3, Integer.toHexString(s), string2}, hscProviderSocket);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._SysProfileClassLogInfo);
            }
        }
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.println("\ndeleteInSysProfile - Deleted association from NVRAM");
        }
        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
        enumeration = CimomWrapper.referenceNames(cIMOMHandle, new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2"), cIMObjectPath2, null).elements();
        if (!enumeration.hasMoreElements() && !bl) {
            if (GlobalConfig.debugLevel((int)2) > 0) {
                System.out.println("\ndeleteInSysProfile - Deleting empty SystemProfile " + cIMObjectPath2);
            }
            Trace.trace("apishscF", "Deleting empty SystemProfile = " + cIMObjectPath2);
            SystemProfileInstProv.deleteSystemProfile(cIMOMHandle, cIMObjectPath2, string, string3, true, hscProviderSocket);
            AsynchEventManager.sendIndication(2, cIMInstance, null);
        }
        Trace.trace("apishscT", "<- deleteInSysProfile");
        if (GlobalConfig.debugLevel((int)2) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
    }
}

